
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Zmetek (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:28:59</b>
	*
	* @author Spinster Generator
*/
public class PeScrap extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT pescrap_id = MeFieldINT.createInstance("pescrap_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldREF perunoperation_id = MeFieldREF.createInstance("perunoperation_id", PeRunOperation.class, "peoperation_id", 0, true);
	MeFieldREF perunpart_id = MeFieldREF.createInstance("perunpart_id", PeRunPart.class, "pepart_id", 0, true);
	MeFieldREF peworker_id = MeFieldREF.createInstance("peworker_id", PeWorker.class, "wkprijmeni", 0, true);
	MeFieldSTRING scpozn = MeFieldSTRING.createInstance("scpozn", "", true);
	MeFieldDATE sccreate = MeFieldDATE.createInstance("sccreate", null, true);

	/** pole dilcu ve vyrobku */
	protected PeRunPartArray m_arrgetRunPartArray = null;

	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PeScrap createInstance() {
		PeScrap newItem = new PeScrap();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PeScrap.m_mapDescParam = new HashMap();
			PeScrap.m_mapDescParam.put("pescrap_id", "GRID_POL_ID");
			PeScrap.m_mapDescParam.put("perunoperation_id", "GRID_POL_PRACOVNIK");
			PeScrap.m_mapDescParam.put("perunpart_id", "GRID_POL_OPERACE");
			PeScrap.m_mapDescParam.put("peworker_id", "GRID_POL_VYROBEK");
			PeScrap.m_mapDescParam.put("scpozn", "GRID_POL_POPIS");
			PeScrap.m_mapDescParam.put("sccreate", "GRID_POL_DATUM");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PeScrap createInstance(int nID) {
		PeScrap newItem = PeScrap.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return pescrap_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "pescrap_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.pescrap_id = ((PeScrap) zdroj).pescrap_id;
		this.perunoperation_id = ((PeScrap) zdroj).perunoperation_id;
		this.perunpart_id = ((PeScrap) zdroj).perunpart_id;
		this.peworker_id = ((PeScrap) zdroj).peworker_id;
		this.scpozn = ((PeScrap) zdroj).scpozn;
		this.sccreate = ((PeScrap) zdroj).sccreate;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 6;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return pescrap_id;
		} else if (nRow == 1) {
			return perunoperation_id;
		} else if (nRow == 2) {
			return perunpart_id;
		} else if (nRow == 3) {
			return peworker_id;
		} else if (nRow == 4) {
			return scpozn;
		} else if (nRow == 5) {
			return sccreate;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("pescrap_id")) {
			return pescrap_id;
		} else if (sName.equals("perunoperation_id")) {
			return perunoperation_id;
		} else if (sName.equals("perunpart_id")) {
			return perunpart_id;
		} else if (sName.equals("peworker_id")) {
			return peworker_id;
		} else if (sName.equals("scpozn")) {
			return scpozn;
		} else if (sName.equals("sccreate")) {
			return sccreate;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(pescrap_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////
	/**
	 	* Vrati pole dilcu ve vyrobku, pokud neexistuje, vytvorime
	 	*
	 	* @return viz popis metody
	*/
	public PeRunPartArray getRunPartArray() {
		// pokud pole neni naplneno
		if (m_arrgetRunPartArray == null) {
			m_arrgetRunPartArray = PeRunPartArray.createInstance();
			m_arrgetRunPartArray.loadArray(MePodminka.createInstance("perunproduct_id", this.getID()));
		}
		return m_arrgetRunPartArray;
	}

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[6];
		arrColumn[0] = MeColumn.createInstance("pescrap_id", PensumContext.getRes(this.getDesc("pescrap_id")), 20);
		arrColumn[1] = MeColumn.createInstance("peworker_id", PensumContext.getRes(this.getDesc("peworker_id")), 100);
		arrColumn[2] = MeColumn.createInstance("perunoperation_id", PensumContext.getRes(this.getDesc("perunoperation_id")), 100);
		arrColumn[3] = MeColumn.createInstance("perunpart_id", PensumContext.getRes(this.getDesc("perunpart_id")), 100);
		arrColumn[4] = MeColumn.createInstance("scpozn", PensumContext.getRes(this.getDesc("scpozn")), 150);
		arrColumn[5] = MeColumn.createInstance("sccreate", PensumContext.getRes(this.getDesc("sccreate")), 100);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr pescrap_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPeScrap() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.pescrap_id.GetInt();
	}

	/**
	  * Nastavi parametr pescrap_id  
	  *
	  * @param pescrap_id hodnota parametru
	*/
	public void setPeScrap(int pescrap_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pescrap_id.SetInt(pescrap_id_temp);
	}
	/**
	  * Vrati hodnotu parametr perunoperation_id  
	  *
	  * @return hodnota parametru
	*/
	public PeRunOperation getPeRunoperation() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeRunOperation) this.perunoperation_id.GetRef();
	}

	/**
	  * Nastavi parametr perunoperation_id  
	  *
	  * @param perunoperation_id hodnota parametru
	*/
	public void setPeRunoperation(PeRunOperation perunoperation_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.perunoperation_id.SetRef(perunoperation_id_temp);
	}
	/**
	  * Vrati hodnotu parametr perunpart_id  
	  *
	  * @return hodnota parametru
	*/
	public PeRunPart getPeRunpart() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeRunPart) this.perunpart_id.GetRef();
	}

	/**
	  * Nastavi parametr perunpart_id  
	  *
	  * @param perunpart_id hodnota parametru
	*/
	public void setPeRunpart(PeRunPart perunpart_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.perunpart_id.SetRef(perunpart_id_temp);
	}
	/**
	  * Vrati hodnotu parametr peworker_id  
	  *
	  * @return hodnota parametru
	*/
	public PeWorker getPeWorker() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeWorker) this.peworker_id.GetRef();
	}

	/**
	  * Nastavi parametr peworker_id  
	  *
	  * @param peworker_id hodnota parametru
	*/
	public void setPeWorker(PeWorker peworker_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.peworker_id.SetRef(peworker_id_temp);
	}
	/**
	  * Vrati hodnotu parametr scpozn  
	  *
	  * @return hodnota parametru
	*/
	public String getScPozn() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.scpozn.GetString();
	}

	/**
	  * Nastavi parametr scpozn  
	  *
	  * @param scpozn hodnota parametru
	*/
	public void setScPozn(String scpozn_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.scpozn.SetString(scpozn_temp);
	}
	/**
	  * Vrati hodnotu parametr sccreate  
	  *
	  * @return hodnota parametru
	*/
	public java.util.Date getScCreate() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (java.util.Date) this.sccreate.GetDate();
	}

	/**
	  * Nastavi parametr sccreate  
	  *
	  * @param sccreate hodnota parametru
	*/
	public void setScCreate(java.util.Date sccreate_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.sccreate.SetDate(sccreate_temp);
	}

}
