
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Relace jednoho uzivatele (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:29:00</b>
	*
	* @author Spinster Generator
*/
public class PeSession extends MeSession {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT pesession_id = MeFieldINT.createInstance("pesession_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldREF ssworker = MeFieldREF.createInstance("ssworker", PeWorker.class, "wkprijmeni", 0, false);
	MeFieldDATE ssplatnost_od = MeFieldDATE.createInstance("ssplatnost_od", null, true);
	MeFieldDATE ssplatnost_do = MeFieldDATE.createInstance("ssplatnost_do", null, true);
	MeFieldSTRING ssrunlog = MeFieldSTRING.createInstance("ssrunlog", "", true);


	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PeSession createInstance() {
		PeSession newItem = new PeSession();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PeSession.m_mapDescParam = new HashMap();
			PeSession.m_mapDescParam.put("pesession_id", "GRID_POL_ID");
			PeSession.m_mapDescParam.put("ssworker", "GRID_POL_PRIJMENI");
			PeSession.m_mapDescParam.put("ssplatnost_od", "GRID_POL_PLATNOST_OD");
			PeSession.m_mapDescParam.put("ssplatnost_do", "GRID_POL_PLATNOST_DO");
			PeSession.m_mapDescParam.put("ssrunlog", "GRID_POL_RUNLOG");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PeSession createInstance(int nID) {
		PeSession newItem = PeSession.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return pesession_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "pesession_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.pesession_id = ((PeSession) zdroj).pesession_id;
		this.ssworker = ((PeSession) zdroj).ssworker;
		this.ssplatnost_od = ((PeSession) zdroj).ssplatnost_od;
		this.ssplatnost_do = ((PeSession) zdroj).ssplatnost_do;
		this.ssrunlog = ((PeSession) zdroj).ssrunlog;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 5;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return pesession_id;
		} else if (nRow == 1) {
			return ssworker;
		} else if (nRow == 2) {
			return ssplatnost_od;
		} else if (nRow == 3) {
			return ssplatnost_do;
		} else if (nRow == 4) {
			return ssrunlog;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("pesession_id")) {
			return pesession_id;
		} else if (sName.equals("ssworker")) {
			return ssworker;
		} else if (sName.equals("ssplatnost_od")) {
			return ssplatnost_od;
		} else if (sName.equals("ssplatnost_do")) {
			return ssplatnost_do;
		} else if (sName.equals("ssrunlog")) {
			return ssrunlog;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(pesession_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO

  /**
	  * Vytvori novy objekt mimo transakci, pouzit jednou pri zavadeni aplikace
	  *
	  * @param nWorkerID ID pracovnika
    * @platnost_od zacatek platnosti session
    * @platnost_do konec platnosti session 
	  * @return novy prvek
	*/
	public static PeSession CreateInstance(int nWorkerID, java.util.Date platnost_od, java.util.Date platnost_do) {
		PeSession newItem = PeSession.createInstance();
		// naplnime pole parametru
		newItem.ssworker.SetRefID(nWorkerID);
    newItem.ssplatnost_od.SetDate(platnost_od);
    newItem.ssplatnost_do.SetDate(platnost_do);
		return newItem;
	}
  
	/**
	 * Vrati jazyk session
	 *
	 * @return    viz popis
	 */
	public int getLang() {
    return this.getSsWorker().getWkLang();
  }

	/**
	 * Vrati cas prihlaseni session
	 *
	 * @return    viz popis
	 */
	public java.util.Date getTimeLogin() {
    return this.getSsPlatnost_od();
  }

	/**
	 * Vrati cas vyprseni platnosti session
	 *
	 * @return    viz popis
	 */
	public java.util.Date getTimeEnd() {
    return this.getSsPlatnost_od();
  }

	/**
	 * Vrati, zda je session jeste platny
	 *
	 * @return    viz popis
	 */
	public boolean isValid() {
    return this.getSsPlatnost_do().after(new java.util.Date());
  }

	/**
	 * Ulozi zaznam do Session
	 *
   * @param sLog text pro ulozeni
	 * @return prubeh akce
	 */
	public boolean saveLog(String sLog) {
    this.setSsRunlog(new java.util.Date() + ": " + sLog + "\n" + this.getSsRunlog());
    return true;
  }

 //@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[4];
		arrColumn[0] = MeColumn.createInstance("pesession_id", PensumContext.getRes(this.getDesc("pesession_id")), 30);
		arrColumn[1] = MeColumn.createInstance("ssworker", PensumContext.getRes(this.getDesc("ssworker")), 300);
		arrColumn[2] = MeColumn.createInstance("ssplatnost_od", PensumContext.getRes(this.getDesc("ssplatnost_od")), 200);
		arrColumn[3] = MeColumn.createInstance("ssplatnost_do", PensumContext.getRes(this.getDesc("ssplatnost_do")), 200);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr pesession_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPeSession() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.pesession_id.GetInt();
	}

	/**
	  * Nastavi parametr pesession_id  
	  *
	  * @param pesession_id hodnota parametru
	*/
	public void setPeSession(int pesession_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pesession_id.SetInt(pesession_id_temp);
	}
	/**
	  * Vrati hodnotu parametr ssworker  
	  *
	  * @return hodnota parametru
	*/
	public PeWorker getSsWorker() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeWorker) this.ssworker.GetRef();
	}

	/**
	  * Nastavi parametr ssworker  
	  *
	  * @param ssworker hodnota parametru
	*/
	public void setSsWorker(PeWorker ssworker_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.ssworker.SetRef(ssworker_temp);
	}
	/**
	  * Vrati hodnotu parametr ssplatnost_od  
	  *
	  * @return hodnota parametru
	*/
	public java.util.Date getSsPlatnost_od() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (java.util.Date) this.ssplatnost_od.GetDate();
	}

	/**
	  * Nastavi parametr ssplatnost_od  
	  *
	  * @param ssplatnost_od hodnota parametru
	*/
	public void setSsPlatnost_od(java.util.Date ssplatnost_od_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.ssplatnost_od.SetDate(ssplatnost_od_temp);
	}
	/**
	  * Vrati hodnotu parametr ssplatnost_do  
	  *
	  * @return hodnota parametru
	*/
	public java.util.Date getSsPlatnost_do() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (java.util.Date) this.ssplatnost_do.GetDate();
	}

	/**
	  * Nastavi parametr ssplatnost_do  
	  *
	  * @param ssplatnost_do hodnota parametru
	*/
	public void setSsPlatnost_do(java.util.Date ssplatnost_do_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.ssplatnost_do.SetDate(ssplatnost_do_temp);
	}
	/**
	  * Vrati hodnotu parametr ssrunlog  
	  *
	  * @return hodnota parametru
	*/
	public String getSsRunlog() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.ssrunlog.GetString();
	}

	/**
	  * Nastavi parametr ssrunlog  
	  *
	  * @param ssrunlog hodnota parametru
	*/
	public void setSsRunlog(String ssrunlog_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.ssrunlog.SetString(ssrunlog_temp);
	}

}
