
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Stavy produktu, dilcu ... (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:29:00</b>
	*
	* @author Spinster Generator
*/
public class PeStatus extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT pestatus_id = MeFieldINT.createInstance("pestatus_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldSTRING stjmeno = MeFieldSTRING.createInstance("stjmeno", "", true);
	MeFieldSTRING stpopis = MeFieldSTRING.createInstance("stpopis", "", true);


	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PeStatus createInstance() {
		PeStatus newItem = new PeStatus();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PeStatus.m_mapDescParam = new HashMap();
			PeStatus.m_mapDescParam.put("pestatus_id", "GRID_POL_ID");
			PeStatus.m_mapDescParam.put("stjmeno", "GRID_POL_JMENO");
			PeStatus.m_mapDescParam.put("stpopis", "GRID_POL_POPIS");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PeStatus createInstance(int nID) {
		PeStatus newItem = PeStatus.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return pestatus_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "pestatus_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.pestatus_id = ((PeStatus) zdroj).pestatus_id;
		this.stjmeno = ((PeStatus) zdroj).stjmeno;
		this.stpopis = ((PeStatus) zdroj).stpopis;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 3;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return pestatus_id;
		} else if (nRow == 1) {
			return stjmeno;
		} else if (nRow == 2) {
			return stpopis;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("pestatus_id")) {
			return pestatus_id;
		} else if (sName.equals("stjmeno")) {
			return stjmeno;
		} else if (sName.equals("stpopis")) {
			return stpopis;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(pestatus_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[3];
		arrColumn[0] = MeColumn.createInstance("pestatus_id", PensumContext.getRes(this.getDesc("pestatus_id")), 30);
		arrColumn[1] = MeColumn.createInstance("stjmeno", PensumContext.getRes(this.getDesc("stjmeno")), 150);
		arrColumn[2] = MeColumn.createInstance("stpopis", PensumContext.getRes(this.getDesc("stpopis")), 350);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr pestatus_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPeStatus() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.pestatus_id.GetInt();
	}

	/**
	  * Nastavi parametr pestatus_id  
	  *
	  * @param pestatus_id hodnota parametru
	*/
	public void setPeStatus(int pestatus_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pestatus_id.SetInt(pestatus_id_temp);
	}
	/**
	  * Vrati hodnotu parametr stjmeno  
	  *
	  * @return hodnota parametru
	*/
	public String getStJmeno() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.stjmeno.GetString();
	}

	/**
	  * Nastavi parametr stjmeno  
	  *
	  * @param stjmeno hodnota parametru
	*/
	public void setStJmeno(String stjmeno_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.stjmeno.SetString(stjmeno_temp);
	}
	/**
	  * Vrati hodnotu parametr stpopis  
	  *
	  * @return hodnota parametru
	*/
	public String getStPopis() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.stpopis.GetString();
	}

	/**
	  * Nastavi parametr stpopis  
	  *
	  * @param stpopis hodnota parametru
	*/
	public void setStPopis(String stpopis_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.stpopis.SetString(stpopis_temp);
	}

}
