
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Jedna bezici uloha (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:28:59</b>
	*
	* @author Spinster Generator
*/
public class PeTask extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT petask_id = MeFieldINT.createInstance("petask_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldREF parent_id = MeFieldREF.createInstance("parent_id", PeTask.class, "tajmeno", 0, true);
	MeFieldSTRING tajmeno = MeFieldSTRING.createInstance("tajmeno", "", true);
	MeFieldDATE tavytvoren = MeFieldDATE.createInstance("tavytvoren", null, true);
	MeFieldREF tastav = MeFieldREF.createInstance("tastav", PeStatus.class, "stjmeno", 0, false);

	/** pole dilcu patricich do tasku */
	protected PeRunPartArray m_arrgetRunPart = null;

	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PeTask createInstance() {
		PeTask newItem = new PeTask();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PeTask.m_mapDescParam = new HashMap();
			PeTask.m_mapDescParam.put("petask_id", "GRID_POL_ID");
			PeTask.m_mapDescParam.put("parent_id", "");
			PeTask.m_mapDescParam.put("tajmeno", "GRID_POL_JMENO");
			PeTask.m_mapDescParam.put("tavytvoren", "GRID_POL_VYTVORENO");
			PeTask.m_mapDescParam.put("tastav", "GRID_POL_STAV");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PeTask createInstance(int nID) {
		PeTask newItem = PeTask.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return petask_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "petask_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.petask_id = ((PeTask) zdroj).petask_id;
		this.parent_id = ((PeTask) zdroj).parent_id;
		this.tajmeno = ((PeTask) zdroj).tajmeno;
		this.tavytvoren = ((PeTask) zdroj).tavytvoren;
		this.tastav = ((PeTask) zdroj).tastav;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 5;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return petask_id;
		} else if (nRow == 1) {
			return parent_id;
		} else if (nRow == 2) {
			return tajmeno;
		} else if (nRow == 3) {
			return tavytvoren;
		} else if (nRow == 4) {
			return tastav;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("petask_id")) {
			return petask_id;
		} else if (sName.equals("parent_id")) {
			return parent_id;
		} else if (sName.equals("tajmeno")) {
			return tajmeno;
		} else if (sName.equals("tavytvoren")) {
			return tavytvoren;
		} else if (sName.equals("tastav")) {
			return tastav;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(petask_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////
	/**
	 	* Vrati pole dilcu patricich do tasku, pokud neexistuje, vytvorime
	 	*
	 	* @return viz popis metody
	*/
	public PeRunPartArray getRunPart() {
		// pokud pole neni naplneno
		if (m_arrgetRunPart == null) {
			m_arrgetRunPart = PeRunPartArray.createInstance();
			m_arrgetRunPart.loadArray(MePodminka.createInstance("peruntask_id", this.getID()));
		}
		return m_arrgetRunPart;
	}

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[4];
		arrColumn[0] = MeColumn.createInstance("petask_id", PensumContext.getRes(this.getDesc("petask_id")), 30);
		arrColumn[1] = MeColumn.createInstance("tajmeno", PensumContext.getRes(this.getDesc("tajmeno")), 150);
		arrColumn[2] = MeColumn.createInstance("tavytvoren", PensumContext.getRes(this.getDesc("tavytvoren")), 100);
		arrColumn[3] = MeColumn.createInstance("tastav", PensumContext.getRes(this.getDesc("tastav")), 50);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr petask_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPeTask() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.petask_id.GetInt();
	}

	/**
	  * Nastavi parametr petask_id  
	  *
	  * @param petask_id hodnota parametru
	*/
	public void setPeTask(int petask_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.petask_id.SetInt(petask_id_temp);
	}
	/**
	  * Vrati hodnotu parametr parent_id  
	  *
	  * @return hodnota parametru
	*/
	public PeTask getPaRent() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeTask) this.parent_id.GetRef();
	}

	/**
	  * Nastavi parametr parent_id  
	  *
	  * @param parent_id hodnota parametru
	*/
	public void setPaRent(PeTask parent_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.parent_id.SetRef(parent_id_temp);
	}
	/**
	  * Vrati hodnotu parametr tajmeno  
	  *
	  * @return hodnota parametru
	*/
	public String getTaJmeno() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.tajmeno.GetString();
	}

	/**
	  * Nastavi parametr tajmeno  
	  *
	  * @param tajmeno hodnota parametru
	*/
	public void setTaJmeno(String tajmeno_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.tajmeno.SetString(tajmeno_temp);
	}
	/**
	  * Vrati hodnotu parametr tavytvoren  
	  *
	  * @return hodnota parametru
	*/
	public java.util.Date getTaVytvoren() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (java.util.Date) this.tavytvoren.GetDate();
	}

	/**
	  * Nastavi parametr tavytvoren  
	  *
	  * @param tavytvoren hodnota parametru
	*/
	public void setTaVytvoren(java.util.Date tavytvoren_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.tavytvoren.SetDate(tavytvoren_temp);
	}
	/**
	  * Vrati hodnotu parametr tastav  
	  *
	  * @return hodnota parametru
	*/
	public PeStatus getTaStav() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeStatus) this.tastav.GetRef();
	}

	/**
	  * Nastavi parametr tastav  
	  *
	  * @param tastav hodnota parametru
	*/
	public void setTaStav(PeStatus tastav_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.tastav.SetRef(tastav_temp);
	}

}
