package cz.luboss.pensum.server;

import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;

// definice
import cz.luboss.medulla.server.MeServerRMI;
import cz.luboss.medulla.common.MeDefine;

// implementace
import cz.luboss.pensum.factory.PensumRMI;
import cz.luboss.pensum.common.*;
import cz.luboss.pensum.gener.*;

/**
	* RMI server pro aplikaci Pensum
	*
	* @author LKC
*/
public class PeServerRMI extends MeServerRMI implements PensumRMI {

	/**
	  * Konstruktor
	  *
	*/
	public PeServerRMI() throws RemoteException {
	  super();
    // naplnime pole session
    m_arrSess = PeSessionArray.createInstance();
	}

	public static void main(String[] args) {
		// nastavime bezpecnost
    if (System.getSecurityManager() == null) {
      System.setSecurityManager(new RMISecurityManager());
    }

		// nastavime Context
		PensumContext.CreateInstance("pensum.cfg", MeDefine.DEF_DATAMACHINE_SQL);

		// a spustime server
    try {
	    String name = PensumContext.getConfParam(PeConfig.REMOTESERVER) 
	    	+ PensumContext.getConfParam(PeConfig.REMOTECLASS);
			PensumRMI rmi = new PeServerRMI();
	    Naming.rebind(name, rmi);
	    System.out.println("Remote Message bound");
    } catch (Exception e) {
      System.err.println("RemoteMessage exception: " + e.getMessage());
    }
	}

	/**
	  * Prida vyrobek do jobu
	  *
	  * @param nSessionID Session
	  * @param job job, do ktereho je treba dat cely vyrobek
	  * @param product vkladany vyrobek
	  * @return prubeh funkce
	*/
	public boolean AddProduct(int nSessionID, PeJob job, PeProduct product) {
    // ulozime log
    if (m_bLogClient) {
      String sLog = "AddProduct(PeJob [" + job.getID() + "], PeProduct [" + product.getID() + "]";
      SaveLog(nSessionID, sLog);
    }
    
    // pokracujeme
    PensumContext.StartTransaction();
		return PensumContext.GetRunMachine().AddProduct(nSessionID, job, product)
      && PensumContext.RollBack();
	}

	/**
	  * Nastavi na produktu a jeho dilcich stav   
	  *
	  * @param nSessionID Session
	  * @param product vyrobek
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavProduct(int nSessionID, PeRunProduct product, int nStav) {
    // ulozime log
    if (m_bLogClient) {
      String sLog = "SetStavProduct(PeRunProduct [" + product.getID() + "], nStav [" + nStav + "]";
      SaveLog(nSessionID, sLog);
    }
    
    // pokracujeme
    PensumContext.StartTransaction();
		return PensumContext.GetRunMachine().SetStavProduct(nSessionID, product, nStav)
      && PensumContext.RollBack();
	}

	/**
	  * Nastavi na dilci a jeho operacich stav
	  *
	  * @param nSessionID Session
	  * @param part dilec
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavPart(int nSessionID, PeRunPart part, int nStav) {
    // ulozime log
    if (m_bLogClient) {
      String sLog = "SetStavPart(PeRunPart [" + part.getID() + "], nStav [" + nStav + "]";
      SaveLog(nSessionID, sLog);
    }
    
    // pokracujeme
    PensumContext.StartTransaction();
		return PensumContext.GetRunMachine().SetStavPart(nSessionID, part, nStav)
      && PensumContext.RollBack();
	}

	/**
	  * Nastavi na operaci stav
	  *
	  * @param nSessionID Session
	  * @param operation operace
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavOper(int nSessionID, PeRunOperation operation, int nStav) {
    // ulozime log
    if (m_bLogClient) {
      String sLog = "SetStavOper(PeRunOperation [" + operation.getID() + "], nStav [" + nStav + "]";
      SaveLog(nSessionID, sLog);
    }
    
    // pokracujeme
    PensumContext.StartTransaction();
		return PensumContext.GetRunMachine().SetStavOper(nSessionID, operation, nStav)
      && PensumContext.RollBack();
	}

}
