/////////////////////////////////////////////////////
//
// Soubor:  OracDlg.cpp
// Popis:   Dialog
// Datum:   10.10.2002
// Autor:   LC
//
// Copyright (C) 2002, MP Orga s.r.o.
// All rights reserved.
//
//////////////////////////////////////////////////////

#include "stdafx.h"
#include "Orac.h"
#include "OracDlg.h"

#include "XMLOrba.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COracDlg dialog

COracDlg::COracDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COracDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COracDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void COracDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COracDlg)
	DDX_Control(pDX, IDC_GET_FROM_DB, m_ctGetFromDB);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(COracDlg, CDialog)
	//{{AFX_MSG_MAP(COracDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_GET_FROM_DB, OnGetFromDb)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COracDlg message handlers

BOOL COracDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	m_ctGetFromDB.SetCheck(BST_UNCHECKED);
	SetParamFromDB(FALSE);

	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// nastavime pocatecni parametry
	GetDlgItem(IDC_DSN)->SetWindowText("TEST");
	GetDlgItem(IDC_USER)->SetWindowText("");
	GetDlgItem(IDC_PASS)->SetWindowText("");
	GetDlgItem(IDC_SQL_QUERY)->SetWindowText("SELECT * FROM TEST");
	GetDlgItem(IDC_TABLENAME)->SetWindowText("TEST");

	// TODO: Add extra initialization here
	GetDlgItem(IDC_XML_FILE)->SetWindowText("test.xml");
	GetDlgItem(IDC_XSLT_FILE)->SetWindowText("test.xsl");
	GetDlgItem(IDC_SOURCE_FILE)->SetWindowText("test.htm");
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void COracDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void COracDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR COracDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void COracDlg::OnOK() 
{
	// nacteme zakladni hodnoty
	bool bRet;
	CString sXMLFile, sXSLFile, sSourceFile;
	GetDlgItem(IDC_XML_FILE)->GetWindowText(sXMLFile);
	GetDlgItem(IDC_XSLT_FILE)->GetWindowText(sXSLFile);
	GetDlgItem(IDC_SOURCE_FILE)->GetWindowText(sSourceFile);

	CXMLOrba cslOrba;
	cslOrba.SetXMLFileNames(sXMLFile);
	cslOrba.SetXSLFileNames(sXSLFile);
	cslOrba.SetXMLSourceFileNames(sSourceFile);

	// pokud se to ma tahat z databaze
	if (m_ctGetFromDB.GetCheck() == BST_CHECKED) {
		CString sDSN, sUser, sPass;
		CString sSQLQuery, sTable;
		
		GetDlgItem(IDC_DSN)->GetWindowText(sDSN);
		GetDlgItem(IDC_USER)->GetWindowText(sUser);
		GetDlgItem(IDC_PASS)->GetWindowText(sPass);
		GetDlgItem(IDC_SQL_QUERY)->GetWindowText(sSQLQuery);
		GetDlgItem(IDC_TABLENAME)->GetWindowText(sTable);

		// otevreme databazku
		CString sConnectStr;
		sConnectStr.Format("DSN=%s;UID=%s;PWD=%s", 
			sDSN.GetBuffer(0), sUser.GetBuffer(0), sPass.GetBuffer(0));
		if (!m_dbDB.OpenEx(sConnectStr))
			return;

		// pretransformujeme strom jako HTML
		bRet = cslOrba.GetXMLTreeFromDB(&m_dbDB, sTable, sSQLQuery);

		// zavreme databazku
		m_dbDB.Close();
	}
	else {
		// pretransformujeme strom jako HTML
		bRet = cslOrba.GetXMLTreeFromFile();
	}

	// probehlo vse v poradku
	if (cslOrba.GetXMLTreeFromFile())
		AfxMessageBox("Transport probhl v podku!");
	else
		AfxMessageBox(cslOrba.GetResut());
}

void COracDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default

	CDialog::OnClose();
}

bool COracDlg::SetParamFromDB(BOOL bCheck)
// nastavi dialog pro vyber z databaze
{
	GetDlgItem(IDC_DSN)->EnableWindow(bCheck);
	GetDlgItem(IDC_USER)->EnableWindow(bCheck);
	GetDlgItem(IDC_PASS)->EnableWindow(bCheck);
	GetDlgItem(IDC_SQL_QUERY)->EnableWindow(bCheck);
	GetDlgItem(IDC_TABLENAME)->EnableWindow(bCheck);

	GetDlgItem(IDC_TEXT_DSN)->EnableWindow(bCheck);
	GetDlgItem(IDC_TEXT_USER)->EnableWindow(bCheck);
	GetDlgItem(IDC_TEXT_PASS)->EnableWindow(bCheck);
	GetDlgItem(IDC_TEXT_SQL_QUERY)->EnableWindow(bCheck);
	GetDlgItem(IDC_TEXT_TABLENAME)->EnableWindow(bCheck);

	return true;
}

void COracDlg::OnGetFromDb() 
{
	// TODO: Add your control notification handler code here
	SetParamFromDB(m_ctGetFromDB.GetCheck() == BST_CHECKED);
}
