/////////////////////////////////////////////////////
//
// Soubor:  XMLOrba.cpp
// Popis:   trida pro export a import stromu v Maestru
// Datum:   010.10.2002
// Autor:   LC
//
// Copyright (C) 2002, MP Orga s.r.o.
// All rights reserved.
//
//////////////////////////////////////////////////////

#include "stdafx.h"
#include "XMLOrba.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CXMLOrba::CXMLOrba()
{
	m_sXMLFile = "";
	m_sXSLFile = "";
	m_sXMLSourceFile = "";
}

CXMLOrba::~CXMLOrba()
{
}

bool CXMLOrba::GetXMLTreeFromDB(CDatabase* pDB, CString sTable, CString sSQLprikaz)
// podame strom jako transformaci z databaze
{
	if (pDB == NULL || !pDB->IsOpen()) {
		m_sDataResult = "Databaze nen otevena !!!";
		return false;
	}

	// otestujeme sSQLprikaz jestli zacina selectem
	sSQLprikaz.TrimLeft();
	if (sSQLprikaz.Left(6).CompareNoCase("SELECT") != 0) {
		m_sDataResult = "SQL pkaz mus zanat pkazem SELECT!";
		return false;
	}

	CRecordset recData(pDB);
	if(!recData.Open(AFX_DB_USE_DEFAULT_TYPE, sSQLprikaz)) {
		m_sDataResult = "Nepodailo se otevt Recordset !!!";
		return false;
	}

	CXmlPluh xmlPluh;
	// nahraje data z recordsetu do XML
	if (!xmlPluh.LoadDataFromDB(recData, sTable)) {
		m_sDataResult.Format("Nepovedlo se vytvorit XML !!!\nChyba : [%s]" , xmlPluh.GetErrorText().GetBuffer(0));
		return false;
	}

	// pokud existuje soubor ulozime
	if (!m_sXMLFile.IsEmpty()) {
		CFile fXMLFile;
		if (!fXMLFile.Open(m_sXMLFile, CFile::modeCreate|CFile::modeWrite)) {
			m_sDataResult = "Nepovedlo se uloit XML !!! ";
			return false;
		}
		CString sData = xmlPluh.GetXMLData(); 
		fXMLFile.Write(sData.GetBuffer(0), sData.GetLength());
		fXMLFile.Close();
	}
	
	// provede transformaci XML dat
	if (!xmlPluh.TransformXMLFromFile(m_sXSLFile)) {
		m_sDataResult.Format("Nepovedlo se transformovat XML !!!\nChyba : [%s]" , xmlPluh.GetErrorText().GetBuffer(0));
		return false;
	}

	// pokud existuje soubor ulozime
	if (!m_sXMLSourceFile.IsEmpty()) {
		CFile fSourceFile;
		if (!fSourceFile.Open(m_sXMLSourceFile, CFile::modeCreate|CFile::modeWrite)) {
			m_sDataResult = "Nepovedlo se uloit trasformovan XML !!! ";
			return false;
		}
		fSourceFile.Write(xmlPluh.GetXMLDataSource().GetBuffer(0), xmlPluh.GetXMLDataSource().GetLength());
		fSourceFile.Close();
	}
	recData.Close();

	m_sDataResult = xmlPluh.GetXMLDataSource();

	return true;
}

bool CXMLOrba::GetXMLTreeFromFile()
// podame strom jako transformaci z databaza
{
	CWaitCursor wc;

	CString sText;
	if (m_sXMLFile.IsEmpty()) {
		m_sDataResult = "Nen zadn vstupn XML soubor !!!";
		return false;
	}

	CXmlPluh xmlPluh;
	// nahraje data z souboru do XML
	if (!xmlPluh.LoadDataFromFile(m_sXMLFile)) {
		m_sDataResult.Format("Nepovedlo se vytvorit XML !!!\nChyba : [%s]" , xmlPluh.GetErrorText().GetBuffer(0));
		return false;
	}

	// provede transformaci XML dat
	if (!xmlPluh.TransformXMLFromFile(m_sXSLFile)) {
		m_sDataResult.Format("Nepovedlo se transformovat XML !!!\nChyba : [%s]" , xmlPluh.GetErrorText().GetBuffer(0));
		return false;
	}

	// pokud existuje soubor ulozime
	if (!m_sXMLSourceFile.IsEmpty()) {
		CFile fSourceFile;
		if (!fSourceFile.Open(m_sXMLSourceFile, CFile::modeCreate|CFile::modeWrite)) {
			m_sDataResult = "Nepovedlo se uloit trasformovan XML !!! ";
			return false;
		}
		fSourceFile.Write(xmlPluh.GetXMLDataSource().GetBuffer(0), xmlPluh.GetXMLDataSource().GetLength());
		fSourceFile.Close();
	}

	m_sDataResult = xmlPluh.GetXMLDataSource();
	return true;
}