/////////////////////////////////////////////////////
//
// Soubor:  XmlPluh.cpp
// Popis:   trida pro praci s XML soubory
//          pouziva rozhrani XOLON 
// Datum:   08.10.2002
// Autor:   LC
//
// Copyright (C) 2002, MP Orga s.r.o.
// All rights reserved.
//
//////////////////////////////////////////////////////

#include "stdafx.h"
#include "XmlPluh.h"

// Base header file.  Must be first.
#include <Include/PlatformDefinitions.hpp>

#if defined(XALAN_OLD_STREAM_HEADERS)
#include <iostream.h>
#include <strstream.h>
#include <fstream.h>
#else
#include <iostream>
#include <strstream>
#include <fstream>
#endif

// Parser
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/dom/DOM.hpp>
#include <xercesc/framework/MemBufFormatTarget.hpp>

#include <xercesc/sax2/ContentHandler.hpp>
#include <xercesc/util/PlatformUtils.hpp>

#include <PlatformSupport/AttributesImpl.hpp>
#include <XalanTransformer/XalanTransformer.hpp>

#include <PlatformSupport/DOMStringHelper.hpp>
#include <PlatformSupport/XalanOutputStreamPrintWriter.hpp>
#include <PlatformSupport/XalanStdOutputStream.hpp>

#include <XSLT/TraceListenerDefault.hpp>

#include "afxpriv.h"

//////////////////////////////////////////////////////////////////////

#if !defined(XALAN_NO_NAMESPACES)
	using std::cerr;
	using std::cout;
	using std::endl;
	using std::istrstream;
	using std::ofstream;
	using std::ostrstream;
	#if defined(XALAN_STRICT_ANSI_HEADERS)
			using std::strlen;
	#endif
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//////////////////////////////////////////////////////////////////////
// signal pouzivani XML DOM

//#define DEF_CREATE_XML_STR
//#define DEF_CREATE_XML_SAX
#define DEF_CREATE_XML_DOM

//////////////////////////////////////////////////////////////////////
// parametry pro preklad do UNICODE

//////////////////////////////////////////////////////////////////////
// options for DOMWriter's features

static const XMLCh*             gOutputEncoding        = 0;
static const XMLCh*             gMyEOLSequence         = 0;

//////////////////////////////////////////////////////////////////////

CXmlPluh::CXmlPluh() {
	m_bDataLoad = false;
	m_theResult = 0;	
	m_sErrorText.Empty();

	m_sXMLData.Empty();
	m_sXMLDataSource.Empty();

	m_pXMLdoc = NULL;

	// Call the static initializer for Xerces.
	XMLPlatformUtils::Initialize();
	// Initialize Xalan.
	XalanTransformer::initialize();
		
	// nastavime kodovani
	gOutputEncoding = XMLString::transcode("windows-1250");
}

CXmlPluh::~CXmlPluh() {

	if (m_pXMLdoc != NULL)
		m_pXMLdoc->release();

	// Terminate Xalan...
	XalanTransformer::terminate();
	// Terminate Xerces...
	XMLPlatformUtils::Terminate();

	// Clean up the ICU, if it's integrated...
	XalanTransformer::ICUCleanUp();

//	delete (void *)gOutputEncoding;        // const problems.
//	delete (void *)gMyEOLSequence;         // const problems.
}

bool CXmlPluh::LoadDataFromDB(CRecordset& recData, CString sName)
// nahraje data z databaze do XML
{
	// pokud je prazdny nic
	if (recData.IsEOF( ))
		return true;

	// nacteme popisy sloupcu
	CStringArray arrField;
	CODBCFieldInfo fieldinfo;
	int FieldCount = recData.GetODBCFieldCount();
	// postupne nacteme hodnoty vsech sloupcu
	for( int nIndex = 0; nIndex < FieldCount; nIndex++ )
	{
		recData.GetODBCFieldInfo( nIndex, fieldinfo );
		fieldinfo.m_strName.MakeLower();
		arrField.Add(fieldinfo.m_strName);
	}

#ifdef DEF_CREATE_XML_STR
	/////////////////////////////////////////////////////////////////////
	//  Tak se vytvari dokument v CStringu
	//////////////////////////////////////////////////////////////////////  

	// ulozime hlavicku
	m_sXMLData = "<?xml version=\"1.0\" encoding=\"windows-1250\"?>\r\n";

	m_sXMLData += "<maestro_data>\r\n";
	// projedem cely recordset 
	CString strFieldValue, sPomoc;
	while ( !recData.IsEOF( ) )
	{
		sPomoc.Format("  <%s>", sName.GetBuffer(0));
		m_sXMLData += sPomoc;

		// postupne nacteme hodnoty vsech sloupcu
		for( int nIndex = 0; nIndex < FieldCount; nIndex++ )
		{
			recData.GetFieldValue( nIndex, strFieldValue );
			// ulozime do XML
			sPomoc.Format("<%s>%s</%s>", arrField[nIndex].GetBuffer(0), strFieldValue.GetBuffer(0),
				arrField[nIndex].GetBuffer(0));
			m_sXMLData += sPomoc;
		}
		sPomoc.Format("</%s>\r\n", sName.GetBuffer(0));
		m_sXMLData += sPomoc;

		recData.MoveNext();
	}
	m_sXMLData += "</maestro_data>";
#endif

#ifdef DEF_CREATE_XML_SAX
	//////////////////////////////////////////////////////////////////////
	//  Tak se vytvari dokument v XML SAX
	//////////////////////////////////////////////////////////////////////  
  
	USES_CONVERSION;
	
	//pokud reloadujeme 
	if(m_bDataLoad)
		m_pXMLdoc->release();

	m_pBuilderXML = m_theXalanTransformer.createDocumentBuilder();

	// Get the SAX2 ContentHandler from the builder...
	ContentHandler* const	theContentHandler = m_pBuilderXML->getContentHandler();
	assert(theContentHandler != 0);

	// This will hold the attributes for the elements we create...
	AttributesImpl	theAttributes;
	theAttributes.clear();

	// Some handy scratch strings for adding elements, attributes, and text nodes...
	XalanDOMString			theElementName, theElementNameChild;
	XalanDOMString			theTextValue;
	const XalanDOMChar		theEmptyString = 0;

	// start the document...
	theContentHandler->startDocument();

	// start the document element...
	assign(theElementName, XALAN_STATIC_UCODE_STRING("maestro_data"));
	theContentHandler->startElement(&theEmptyString, &theEmptyString, c_wstr(theElementName), theAttributes);

	// projedem cely recordset 
	CString strFieldValue;
	while ( !recData.IsEOF( ) )
	{
		// Set the name of the element...
		assign(theElementName, XalanDOMString(sName.GetBuffer(0)));
		theContentHandler->startElement(&theEmptyString, &theEmptyString, c_wstr(theElementName), theAttributes);

		// postupne nacteme hodnoty vsech sloupcu
		for( int nIndex = 0; nIndex < FieldCount; nIndex++ )
		{
			recData.GetFieldValue( nIndex, strFieldValue );

			// Set the name of the element...
			assign(theElementNameChild, XalanDOMString(arrField[nIndex].GetBuffer(0)));
			theContentHandler->startElement(&theEmptyString, &theEmptyString, c_wstr(theElementNameChild), theAttributes);

			// Add a text node...
			assign(theTextValue, XalanDOMString(T2OLE(strFieldValue.GetBuffer(0))));
			theContentHandler->characters(c_wstr(theTextValue), length(theTextValue));

			// End the element...
			theContentHandler->endElement(&theEmptyString, &theEmptyString, c_wstr(theElementNameChild));
		}

		// End the element...
		theContentHandler->endElement(&theEmptyString, &theEmptyString, c_wstr(theElementName));

		recData.MoveNext();
	}

	// end the document element...
	assign(theElementName, XalanDOMString("maestro_data"));

	theContentHandler->endElement(&theEmptyString, &theEmptyString, c_wstr(theElementName));

	// end the document...
	theContentHandler->endDocument();
/*
	XalanDOMString prd = m_pBuilderXML->getURI();
	int p1 = prd.size();
	int p2 = prd.length();
	int p3 = prd.max_size();

	const XalanDOMChar* e1 = prd.c_str();
	const XalanDOMChar* e2 = prd.data();

	CString t1 = (char*)e1;
	CString t2 = (char*)e2;


	XalanOutputStreamPrintWriter pWriter;
	char* s;
	pWriter->write(s);
*/
#endif

#ifdef DEF_CREATE_XML_DOM
	//////////////////////////////////////////////////////////////////////
	//  Tak se vytvari dokument v XML DOM
	//////////////////////////////////////////////////////////////////////  

	USES_CONVERSION;

	m_pXMLimpl =  DOMImplementationRegistry::getDOMImplementation(XMLString::transcode("Core"));
	m_pXMLdoc = m_pXMLimpl->createDocument(
			0,                    // root element namespace URI.
			XMLString::transcode("maestro_data"),         // root element name
			0);                   // document type object (DTD).

	DOMElement* rootElem = m_pXMLdoc->getDocumentElement();

	// projedem cely recordset 
	CString strFieldValue, sPomoc;
	while ( !recData.IsEOF( ) )
	{
		DOMElement* prodElem = m_pXMLdoc->createElement(XMLString::transcode(sName.GetBuffer(0)));
		rootElem->appendChild(prodElem);

		// postupne nacteme hodnoty vsech sloupcu
		for( int nIndex = 0; nIndex < FieldCount; nIndex++ )
		{
			recData.GetFieldValue( nIndex, strFieldValue );

			DOMElement* prodChild = m_pXMLdoc->createElement(XMLString::transcode(arrField[nIndex].GetBuffer(0)));
			prodElem->appendChild(prodChild);

			DOMText* prodChildDataVal = m_pXMLdoc->createTextNode(T2OLE(strFieldValue.GetBuffer(0)));
			prodChild->appendChild(prodChildDataVal);
		}

		recData.MoveNext();
	}
#endif

	m_bDataLoad = true;
	return true;
}

// nahraje data z souboru do XML
bool CXmlPluh::LoadDataFromFile(CString sXMLFile)
{
	m_sXMLData = "";
   TRY
   {
		// nacteme cely soubor do retezce
		CFile fXMLFile;
		if (!fXMLFile.Open(sXMLFile, CFile::modeRead)) {
			m_sErrorText = "Nepovedlo otevt XML !!!";
			return false;
		}
		char * sData = new char[fXMLFile.GetLength() + 1];
		sData[fXMLFile.GetLength()] = '\0';
		fXMLFile.Read(sData, fXMLFile.GetLength());
		m_sXMLData = sData;
		fXMLFile.Close();
		delete sData;
	}
   CATCH(CFileException, pEx)
   {
      // Simply show an error message to the user.
      pEx->ReportError();
		return false;
   }
   AND_CATCH(CMemoryException, pEx)
   {
      // We can't recover from this memory exception, so we'll
      // just terminate the app without any cleanup. Normally, an
      // an application should do everything it possibly can to
      // clean up properly and _not_ call AfxAbort().
      AfxAbort();
		return false;
	}
	END_CATCH

	m_bDataLoad = true;
	return true;
}

bool CXmlPluh::TransformXML(CString sXSLTData)
// provede transformaci XML dat
{
	if (!IsDataLoad()) {
		m_sErrorText = "Data nejsou naplnna !!!!!";
		return true;
	}
	if (sXSLTData.IsEmpty()) {
		m_sErrorText = "XSLT data jsou przdn !!!!!";
		return true;
	}

	int	theResult = -1;
	ostrstream	theErrorOut;

	try {
		// Our input streams...
#ifdef DEF_CREATE_XML_DOM
		istrstream	theXMLStream(m_sXMLData.GetBuffer(0), m_sXMLData.GetLength());
#endif
		istrstream	theXSLStream(sXSLTData.GetBuffer(0), sXSLTData.GetLength());

		XSLTInputSource	inputSource(&theXSLStream);
		inputSource.setSystemId(c_wstr(XalanDOMString("foo")));

		ostrstream	theFormatterOut;

		// Do the transform.
#ifdef DEF_CREATE_XML_SAX

		// TraceListener flags...
		bool traceTemplates = false;
		bool traceTemplateChildren = false;
		bool traceGenerationEvent = false;
		bool traceSelectionEvent = false;

		// Set up a diagnostic writer to be used by the TraceListener...
		XalanStdOutputStream			theStdErr(theErrorOut);
		XalanOutputStreamPrintWriter	diagnosticsWriter(theStdErr);

		// Make sure that error reporting, which includes any TraceListener output
		// does not throw exceptions when transcoding, since that could result in
		// an exception being thrown while another exception is active.  In particular,
		// characters that the TraceListener writes might not be representable in the
		// local code page.
		theStdErr.setThrowTranscodeException(false);

		// Set up the TraceListener... 
		TraceListenerDefault		theTraceListener(				
				diagnosticsWriter,
				traceTemplates,
				traceTemplateChildren,
				traceGenerationEvent,
				traceSelectionEvent);

		// Add the TraceListener to the XalanTransformer instance...
		m_theXalanTransformer.addTraceListener(&theTraceListener);

		theResult = m_theXalanTransformer.transform(*m_pBuilderXML, inputSource, theFormatterOut);
#endif

#ifdef DEF_CREATE_XML_DOM
		theResult = m_theXalanTransformer.transform(&theXMLStream, inputSource, theFormatterOut);
#endif

		// a ulozime do stringu
		m_sXMLDataSource = theFormatterOut.str();
		m_sXMLDataSource = m_sXMLDataSource.Left(theFormatterOut.pcount());
		
		if(theResult != 0) {
			m_sErrorText =  m_theXalanTransformer.getLastError();
			return false;
		}
	}
	catch(...)
	{
		m_sErrorText = m_theXalanTransformer.getLastError();

		int nCount = theErrorOut.pcount();
		char* sXML = (char*)malloc(nCount + 1);
		sXML[nCount] ='\0';
		memcpy(sXML, theErrorOut.str(), nCount);

		return false;
	}

	// ulozime vysledek
	m_theResult = theResult;
	return (theResult == 0);
}


bool CXmlPluh::TransformXMLFromFile(CString sXSLFile)
// provede transformaci XML dat XSLT nacte ze souboru
{
	CString sXSLData = "";
   TRY
   {
		// nacteme cely soubor do retezce
		CFile fXSLFile;
		if (!fXSLFile.Open(sXSLFile, CFile::modeRead)) {
			m_sErrorText = "Nepovedlo otevt XSLT !!!";
			return false;
		}
		char * sData = new char[fXSLFile.GetLength() + 1];
		sData[fXSLFile.GetLength()] = '\0';
		fXSLFile.Read(sData, fXSLFile.GetLength());
		sXSLData = sData;
		fXSLFile.Close();
		delete sData;
	}
   CATCH(CFileException, pEx)
   {
      // Simply show an error message to the user.
      pEx->ReportError();
		return false;
   }
   AND_CATCH(CMemoryException, pEx)
   {
      // We can't recover from this memory exception, so we'll
      // just terminate the app without any cleanup. Normally, an
      // an application should do everything it possibly can to
      // clean up properly and _not_ call AfxAbort().
      AfxAbort();
		return false;
	}
	END_CATCH

	return TransformXML(sXSLData);
}

CString CXmlPluh::GetXMLData()
// vrati naplneny XML data
{

#ifdef DEF_CREATE_XML_STR
#endif

#ifdef DEF_CREATE_XML_SAX
#endif

#ifdef DEF_CREATE_XML_DOM
	// vytiskne cele XML do retezce
	char* sText = "AAA";
	if (!PrintXMLDOM(m_pXMLdoc, &sText))
		return "";

	m_sXMLData = sText;
#endif

	return m_sXMLData;
}

CString CXmlPluh::GetXMLDataSource() 
// vrati XML data po transformaci
{
	return m_sXMLDataSource;
}

bool CXmlPluh::PrintXMLDOM(DOMDocument* doc, char** sText)
// vytiskne cele XML do retezce
{
	try
	{
		// get a serializer, an instance of DOMWriter
		XMLCh tempStr[100];
		XMLString::transcode("LS", tempStr, 99);
		DOMImplementation *impl          = DOMImplementationRegistry::getDOMImplementation(tempStr);
		DOMWriter         *theSerializer = ((DOMImplementationLS*)impl)->createDOMWriter();

		// set user specified end of line sequence and output encoding
		theSerializer->setNewLine(gMyEOLSequence);
		theSerializer->setEncoding(gOutputEncoding);

		MemBufFormatTarget * myFormTarget = new MemBufFormatTarget();
		// do the serialization through DOMWriter::writeNode();
		theSerializer->writeNode(myFormTarget, *doc);

		// zapisemem do stringu
		int nCount = myFormTarget->getLen();
		*sText = (char*)malloc(nCount + 1);
		(*sText)[nCount] = '\0';
		memcpy(*sText, (char*)myFormTarget->getRawBuffer(), nCount + 1);

		delete theSerializer;
		delete myFormTarget;
	}
	catch (XMLException& e)
	{
		m_sErrorText = "An error occurred during creation of output transcoder. Msg is:\n";
		m_sErrorText += XMLString::transcode(e.getMessage());
	}

	return true;
}