/////////////////////////////////////////////////////
//
// Soubor:  XmlPluh.h
// Popis:   trida pro praci s XML soubory
//          pouziva rozhrani XOLON 
// Datum:   08.10.2002
// Autor:   LC
//
// Copyright (C) 2002, MP Orga s.r.o.
// All rights reserved.
//
//////////////////////////////////////////////////////

#ifndef _XMLPLUH_H_
#define _XMLPLUH_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <XalanTransformer/XalanDocumentBuilder.hpp>
#include <XalanTransformer/XalanTransformer.hpp>

//////////////////////////////////////////////////////////////////////

class DOMImplementation;
class DOMDocument;

class XalanDocumentBuilder;

class CXmlPluh
{
public :
	CXmlPluh();
	~CXmlPluh();

	// nahraje data z recordsetu do XML
	bool LoadDataFromDB(CRecordset& recData, CString sName);
	// nahraje data z souboru do XML
	bool LoadDataFromFile(CString sXMLFile);
	
	// provede transformaci XML dat
	bool TransformXML(CString sXSLTData);
	// provede transformaci XML dat XSLT nacte ze souboru
	bool TransformXMLFromFile(CString sXSLFile);

	// vrati zda jsme data nahrali	
	bool IsDataLoad() {return m_bDataLoad;};
	// vrati cislo chyby posledniho importu
	int GetErrorNum() {return m_theResult;};
	// vrati text chyby posledniho importu
	CString GetErrorText() {return m_sErrorText;};

	// vrati naplneny XML data
	CString  GetXMLData();
	// vrati XML data po transformaci
	CString  GetXMLDataSource();

	// vytiskne cele XML do retezce
	bool PrintXMLDOM(DOMDocument* doc, char** sText);

private :
	// zda jsme data nahrali	
	bool		m_bDataLoad;
	// cislo chyby posledniho importu
	int		m_theResult;	
	// text chyby posledniho importu
	CString  m_sErrorText;

	// creator
	DOMImplementation* m_pXMLimpl;
	// dokument XML
	DOMDocument* m_pXMLdoc;
	// XSL dokument

	DOMDocument* m_pXSLdoc;

	XalanTransformer	m_theXalanTransformer;
	XalanDocumentBuilder*  m_pBuilderXML;

	// naplneny XML data, XML data po transformaci
	CString  m_sXMLData;
	CString  m_sXMLDataSource;
};

#endif // _XMLPLUH_H_