
package cz.luboss.spinster;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.parsers.DocumentBuilder; 
import javax.xml.parsers.DocumentBuilderFactory;  
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;  

/**
 * Aplikace pro generovani polozek do do projektu Medulla
 *  
 * @author LKC
 */
public class Spinster {

  /** cislo verze */
	public static String VERSION = "0.3";

  /** Formatovac casu generovani */
	private static SimpleDateFormat m_forDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

	/** Jmeno vzoroveho souboru s vzorem cele tridy */
	public static String DEF_FILE_VZOR = "item.pat";
	/** Jmeno vzoroveho souboru s vzorem cele tridy PeParamDB */
	public static String DEF_FILE_VZOR_SQLPARAM = "item_sqlparam.pat";
	/** Jmeno vzoroveho souboru s vzorem funkci Set.. a Get.. */
	public static String DEF_FILE_VZOR_SETGETMETODS = "item_setgetmetods.pat";
	/** Jmeno vzoroveho souboru s vzorem funkce GetColumns */
	public static String DEF_FILE_VZOR_GETCOLUMNS = "item_getcolumns.pat";
	/** Jmeno vzoroveho souboru s vzorem tridy pole */
	public static String DEF_FILE_VZOR_ARRAY = "item_array.pat";
	/** Jmeno vzoroveho souboru s vzorem vazby na jine pole */
	public static String DEF_FILE_VZOR_GETSUBARRAY = "item_getsubarray.pat";

	/** Protoze se to furt prepisuje nastavime hodnoty v poli textu */
	/** Jmeno tridy */
	public static int ID_FORM_CLASS_NAME = 0;
	/** Jmeno tabulky */
	public static int ID_FORM_TABLE_NAME = 1;
	/** Datum generovani */
	public static int ID_FORM_DATE = 2;
	/** Patrametry objektu */
	public static int ID_FORM_FIELDS = 3;
	/** Funkce pro subpole */
	public static int ID_FORM_SUBARRY = 4;
	/** Funkce napsane uzivatelem (nebude generovano) */
	public static int ID_FORM_NEGENEROVANO = 5;
	/** set.. get.. funkce */
	public static int ID_FORM_SETGET_METODS = 6;
	/** Popisy patrametru objektu */
	public static int ID_FORM_FIELDS_DESC = 7;
	/** Vazby na sub pole */
	public static int ID_FORM_ATRIBUTES = 8;
	/** Jmeno nadrazene tridy */
	public static int ID_FORM_PARENT_CLASS = 9;
	/** poradi parametru s ID */
	public static int ID_FORM_PORADI_ID = 10;
  /** jmeno parametru s ID */
  public static int ID_FORM_NAME_ID = 11;
	/** pocet parametru */
	public static int ID_FORM_SET_DATA = 12;
	/** pocet parametru */
	public static int ID_FORM_PARAMETR_COUNT = 13;
	/** pocet parametru */
	public static int ID_FORM_GET_PARAM_INT = 14;
	/** pocet parametru */
	public static int ID_FORM_GET_PARAM_STRING = 15;

	/** 
	  * Spusti generovani
	  *
    * @param args pole vstupnich parametru
	*/
	public static void main(String[] args) {
		System.out.println("\n");
		System.out.println("Spinster verze " + Spinster.VERSION + " - Generator JAVA trid pro projekt Medulla");
		System.out.println("\n");
		// parametry
		String sXMLFile = "";
		String sSourceDir = "";
    String sParamClass = "";
		// nacteme
		for (int i = 0; i < args.length; i++) {
			if (args[i].startsWith("xmlfile=")) {
				sXMLFile =  args[i].substring(8, args[i].length()); 
			} else if (args[i].startsWith("sourcedir=")) { 
				sSourceDir =  args[i].substring(10, args[i].length()); 
			} else if (args[i].startsWith("paramclass=")) { 
				sParamClass =  args[i].substring(11, args[i].length()); 
			}
		}
		// zkontorlujeme
		String sError = "";
		if (sXMLFile.length() == 0) {
			sError += "  Spatne zadany vstupni XML soubor!";
		}
		if (sSourceDir.length() == 0) {
			sError += "  Spatne zadany vystupni adresar!";
		}
							
		// spatne zadane parametry
		if (sError.length() != 0) {
			System.out.println("Zadal jste spatne parametry :");
			System.out.println(sError);
			PrintCommnadLine();
			return;
		}

		// zapiseme z ktereho souboru se bude generovat
		System.out.println("  Generuje se podle souboru " + sXMLFile + "\n");

		// nactem temp soubory
		String sFileClassSource = Spinster.LoadFile(DEF_FILE_VZOR); 
		if (sFileClassSource == null) {
			System.out.println("Nepodarilo se nahrat temp soubor [" + DEF_FILE_VZOR + "]");
			PrintCommnadLine();
			return;
		}
		String sFileArraySource = Spinster.LoadFile(DEF_FILE_VZOR_ARRAY); 
		if (sFileArraySource == null) {
			System.out.println("Nepodarilo se nahrat temp soubor [" + DEF_FILE_VZOR_ARRAY + "]");
			PrintCommnadLine();
			return;
		}
		String sGetSQLParamSource = Spinster.LoadFile(DEF_FILE_VZOR_SQLPARAM);
		if (sGetSQLParamSource == null) {
			System.out.println("Nepodarilo se nahrat temp soubor [" + DEF_FILE_VZOR_SQLPARAM + "]");
			PrintCommnadLine();
			return;
		}
		String sSetGetMetodsSource = Spinster.LoadFile(DEF_FILE_VZOR_SETGETMETODS); 
		if (sSetGetMetodsSource == null) {
			System.out.println("Nepodarilo se nahrat temp soubor [" + DEF_FILE_VZOR_SETGETMETODS + "]");
			PrintCommnadLine();
			return;
		}
		String sGetColumnsSource = Spinster.LoadFile(DEF_FILE_VZOR_GETCOLUMNS); 
		if (sGetColumnsSource == null) {
			System.out.println("Nepodarilo se nahrat temp soubor [" + DEF_FILE_VZOR_GETCOLUMNS + "]");
			PrintCommnadLine();
			return;
		}
		String sGetSubArraySource = Spinster.LoadFile(DEF_FILE_VZOR_GETSUBARRAY); 
		if (sGetSubArraySource == null) {
			System.out.println("Nepodarilo se nahrat temp soubor [" + DEF_FILE_VZOR_GETSUBARRAY + "]");
			PrintCommnadLine();
			return;
		}
		
		// pole popisu
		String[] arrFormPopisy = new String[16];
    // trida s SQl prikazy
    String[] arrSQLPopisy = {sParamClass, "", "", "", "", "", "", "", ""};
    
    // generovane casti
		String sGetSQL_INSERT = "";
		String sGetSQL_SELECT = "";
		String sGetSQL_SELECT_ARRAY = "";    
		String sLoadParam = "";
		String sLoadParamDesc = "";
		String sGetSelectSQL = "";
		String sGetSelectFields = "";
		String sViews = "";
		String sSetGetMetods = "";
		String sGetSubArrayItem = ""; 
		String sGetSubArrayFun = "";

		try {
			// rozparsujeme file
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse( new File(sXMLFile) );

			// projedem vsechny polozky Item
			Element elem = document.getDocumentElement();
			NodeList arrItem = elem.getChildNodes(); 
			for (int i = 0; i < arrItem.getLength(); i++) {
				Node item = arrItem.item(i);
				// pokud je jmeno prazdne, dalsi
				if (item.getNodeType() == Node.TEXT_NODE) {
					continue;
				}
				// generovane casti
				sGetSQL_INSERT = ""; sGetSQL_SELECT = ""; sGetSQL_SELECT_ARRAY = "";sLoadParam = ""; sLoadParamDesc = ""; 
        sGetSelectSQL = ""; sGetSelectFields = ""; sViews = ""; sSetGetMetods = ""; sGetSubArrayItem = ""; 
        sGetSubArrayFun = ""; String sSetData = ""; String sGetParamINT = ""; String sGetParamSTRING = "";

        // pokud se jedna o jmeno databazoveho ovladace
        if (item.getNodeName().equals("DRIVERNAME")) {
          arrSQLPopisy[7] = item.getFirstChild() == null ? "" : item.getFirstChild().getNodeValue();
					continue;
        } else if (item.getNodeName().equals("SEQUENCE_TABLE")) {
          arrSQLPopisy[8] = item.getFirstChild() == null ? "" : item.getFirstChild().getNodeValue();
					continue;
        }

				// projedem cely prvek Item
				NodeList arrParam = item.getChildNodes();
				for (int j = 0; j < arrParam.getLength(); j++) {
					Node param = arrParam.item(j);
					// pokud je jmeno prazdne, dalsi
					if (param.getNodeType() == Node.TEXT_NODE) {
						continue;
					}
					// rozdelime podle hodnot
					if (param.getNodeName().equals("NAME")) {
						arrFormPopisy[ID_FORM_CLASS_NAME] = 
							param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue();
					} else if (param.getNodeName().equals("PARENT")) {
						arrFormPopisy[ID_FORM_PARENT_CLASS] = 
							param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue(); 
					} else if (param.getNodeName().equals("PORADI_ID")) {
						arrFormPopisy[ID_FORM_PORADI_ID] = 
							param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue(); 
					} else if (param.getNodeName().equals("DESCRIPTION")) {
						arrFormPopisy[ID_FORM_TABLE_NAME] = 
							param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue(); 
					} else if (param.getNodeName().equals("INSERT_TABLE")) {
            sGetSQL_INSERT = "if (item instanceof " + arrFormPopisy[ID_FORM_CLASS_NAME] + ") {\n\t\t\treturn \""
              + (param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue()) + "\";\n\t\t} else ";
					} else if (param.getNodeName().equals("FIELD_SQL")) {
            sGetSQL_SELECT = "if (item instanceof " + arrFormPopisy[ID_FORM_CLASS_NAME] + ") {\n\t\t\treturn \""
              + (param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue()) + "\";\n\t\t} else ";
            sGetSQL_SELECT_ARRAY = "if (array instanceof " + arrFormPopisy[ID_FORM_CLASS_NAME] 
              + "Array) {\n\t\t\treturn \"" + (param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue()) 
              + "\";\n\t\t} else ";
					} else if (param.getNodeName().equals("FIELD_ARRAY")) {
						int nFieldCount = 0;
						// projedem vsechny parametry polozky
						NodeList arrFields = param.getChildNodes();
						for (int k = 0; k < arrFields.getLength(); k++) {
							Node field = arrFields.item(k);
							// pokud je jmeno prazdne, dalsi
							if (field.getNodeType() == Node.TEXT_NODE) {
								continue;
							}
							// projedem obsah polozky
							String sName = ""; String sType = ""; String sDef = ""; String sEdit = ""; String sDesc = ""; 
              String sRefClass = ""; String sRefName = "";
							NodeList arrFieldName = field.getChildNodes();
							for (int l = 0; l < arrFieldName.getLength(); l++) {
								Node fieldName = arrFieldName.item(l);
								// pokud je jmeno prazdne, dalsi
								if (fieldName.getNodeType() == Node.TEXT_NODE) {
									continue;
								}
								// rozdelime podle hodnot
								if (fieldName.getNodeName().equals("NAME")) {
									sName = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								} else if (fieldName.getNodeName().equals("TYPE")) {
									sType = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								} else if (fieldName.getNodeName().equals("REF_CLASS")) {
									sRefClass = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								} else if (fieldName.getNodeName().equals("REF_NAME")) {
									sRefName = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								} else if (fieldName.getNodeName().equals("DEFAULT")) {
									sDef = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								} else if (fieldName.getNodeName().equals("EDIT")) {
									sEdit = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								} else if (fieldName.getNodeName().equals("DESCRIPTION")) {
									sDesc = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								}
							}
							// najdeme spravny default
							sDef = Spinster.FindDefault(sType, sDef);
							// slozime do hromady zaznam do pole parametru
							sLoadParam += "\t" + sType + " " + sName + " = " + sType + ".createInstance(\"" 
                + sName + "\", ";
              // pokud se jedna o referenci musi pridat jmeno tridy a jemno polozky ve tride
              if (sType.equals("MeFieldREF")) {
                sLoadParam += sRefClass + ".class, \"" + sRefName + "\", ";
              }
              sLoadParam += sDef + ", " + sEdit + ");\n";
							// a do pole popisu parametru
							sLoadParamDesc += "\t\t\t" + arrFormPopisy[ID_FORM_CLASS_NAME] + ".m_mapDescParam.put(\"" 
                + sName + "\", \"" + sDesc + "\");\n";
							// pridame k set get metodam
							sSetGetMetods += Spinster.GenerGetSetMetods(sSetGetMetodsSource, sName, sType, sRefClass);
              // pokud je to parametr s ID
              if (Integer.parseInt(arrFormPopisy[ID_FORM_PORADI_ID]) == nFieldCount) {
                arrFormPopisy[ID_FORM_NAME_ID] = sName;
              }
              // vytvorime funkci SetData
              sSetData += "\t\tthis." + sName + " = ((" + arrFormPopisy[ID_FORM_CLASS_NAME] + ") zdroj)." 
                + sName + ";\n";
              // vytvorime funkci GetParam(INT)
              sGetParamINT += "if (nRow == " + nFieldCount + ") {\n\t\t\treturn " + sName + ";\n\t\t} else ";
              // vytvorime funkci GetParam(STRING)
              sGetParamSTRING += "if (sName.equals(\"" + sName + "\")) {\n\t\t\treturn " + sName + ";\n\t\t} else ";
							nFieldCount++;
						}
						// vytvorime celek
						arrFormPopisy[ID_FORM_ATRIBUTES] = "\t// Parametry\n" + sLoadParam + "\n";
						arrFormPopisy[ID_FORM_FIELDS] = "\t\t\t// naplnime pole popisu parametru\n" 
              + "\t\t\t" + arrFormPopisy[ID_FORM_CLASS_NAME] + ".m_mapDescParam = new HashMap();\n"
							+ sLoadParamDesc;
            // pocet parametru
            arrFormPopisy[ID_FORM_PARAMETR_COUNT] = String.valueOf(nFieldCount);
            arrFormPopisy[ID_FORM_SET_DATA] = sSetData;
            // vytvorime funkci GetParam(INT)
            arrFormPopisy[ID_FORM_GET_PARAM_INT] = sGetParamINT;
            // vytvorime funkci GetParam(STRING)
            arrFormPopisy[ID_FORM_GET_PARAM_STRING] = sGetParamSTRING;
					} else if (param.getNodeName().equals("SELECT_SQL")) {
						sGetSelectSQL = "\t\t\treturn \"" 
              + (param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue()) + "\";\n"; 
					} else if (param.getNodeName().equals("SELECT_ARRAY")) {
						int nSelectCount = 0;
						// projedem vsechny parametry vyberoveho Gridu
						NodeList arrGrid = param.getChildNodes();
						for (int k = 0; k < arrGrid.getLength(); k++) {
							Node grid = arrGrid.item(k);
							// pokud je jmeno prazdne, dalsi
							if (grid.getNodeType() == Node.TEXT_NODE) {
								continue;
							}
							// projedem obsah polozky
							sGetSelectFields += "\t\t\tarrPopisy[" + nSelectCount + "] = \"" 
                + (grid.getFirstChild() == null ? "" : grid.getFirstChild().getNodeValue()) + "\";\n";
							nSelectCount++;
						}
						sGetSelectFields = "\t\t\tString[] arrPopisy = new String[" + nSelectCount + "];\n" + sGetSelectFields 
              + "\t\t\treturn arrPopisy;\n";
					} else if (param.getNodeName().equals("VIEW_ARRAY")) {
						int nViewCount = 0;
						// projedem vsechny parametry polozky
						NodeList arrFields = param.getChildNodes();
						for (int k = 0; k < arrFields.getLength(); k++) {
							Node field = arrFields.item(k);
							// pokud je jmeno prazdne, dalsi
							if (field.getNodeType() == Node.TEXT_NODE) {
								continue;
							}
							// projedem obsah polozky
							String sName = ""; String sDesc = ""; String sWidth = "";
							NodeList arrFieldName = field.getChildNodes();
							for (int l = 0; l < arrFieldName.getLength(); l++) {
								Node fieldName = arrFieldName.item(l);
								// pokud je jmeno prazdne, dalsi
								if (fieldName.getNodeType() == Node.TEXT_NODE) {
									continue;
								}
								// rozdelime podle hodnot
								if (fieldName.getNodeName().equals("NAME")) {
									sName = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								} else if (fieldName.getNodeName().equals("DESCRIPTION")) {
									sDesc = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								} else if (fieldName.getNodeName().equals("WIDTH")) {
									sWidth = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								}
							}
							// pokud nebyl zadan popis, dame defaultni
							if (sDesc == null || sDesc.length() == 0) {
								sDesc = "PensumContext.getRes(this.getDesc(\"" + sName + "\"))"; 
							} else {
								sDesc = "PensumContext.getRes(\"" + sDesc + "\")";
							}
							// slozime do hromady
							sViews += "\t\tarrColumn[" + nViewCount + "] = MeColumn.createInstance(\"" + sName + "\", " + sDesc 
                + ", " + sWidth + ");\n"; 
							nViewCount++;
						}
						// vytvorime celek
						sViews = MessageFormat.format(sGetColumnsSource, new String[] {String.valueOf(nViewCount), sViews});
					} else if (param.getNodeName().equals("SUB_ARRAY")) {
						int nViewCount = 0;
						// projedem vsechny parametry polozky
						NodeList arrFields = param.getChildNodes();
						for (int k = 0; k < arrFields.getLength(); k++) {
							Node field = arrFields.item(k);
							// pokud je jmeno prazdne, dalsi
							if (field.getNodeType() == Node.TEXT_NODE) {
								continue;
							}
							// projedem obsah polozky
							String[] arrSubArray = new String[4];
							NodeList arrFieldName = field.getChildNodes();
							for (int l = 0; l < arrFieldName.getLength(); l++) {
								Node fieldName = arrFieldName.item(l);
								// pokud je jmeno prazdne, dalsi
								if (fieldName.getNodeType() == Node.TEXT_NODE) {
									continue;
								}
								// rozdelime podle hodnot
								if (fieldName.getNodeName().equals("NAME")) {
									arrSubArray[0] = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								} else if (fieldName.getNodeName().equals("DESCRIPTION")) {
									arrSubArray[1] = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								} else if (fieldName.getNodeName().equals("ID_NAME")) {
									arrSubArray[2] = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								} else if (fieldName.getNodeName().equals("TYPE")) {
									arrSubArray[3] = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
								}
							}
							// naplnime vazbu na pole
							sGetSubArrayItem += "\t/** " + arrSubArray[1] + " */\n\tprotected " + arrSubArray[3]
								+ " m_arr" + arrSubArray[0] + " = null;\n";
							// naplnime funkci ktera nam vazbu poda
							sGetSubArrayFun += MessageFormat.format(sGetSubArraySource, arrSubArray);
						}
					}
				}
			
				// pokud trida nema GetSQL_SELECT dame vyjimku
				if (sGetSelectSQL.length() == 0) {
					sGetSelectSQL = "\t\t\tthrow new cz.luboss.lubosslib.LException(this.getClass(), \"Prvek tridy " 
						+ arrFormPopisy[ID_FORM_CLASS_NAME]  + " nema vyberovy SELECT.\");\n";
				}
				sGetSelectSQL = "if (item instanceof " + arrFormPopisy[ID_FORM_CLASS_NAME] + ") {\n"
          + sGetSelectSQL + "\t\t} else ";
				
				// pokud trida nema GetSelectFields dame vyjimku
				if (sGetSelectFields.length() == 0) {
					sGetSelectFields  = "\t\t\tthrow new cz.luboss.lubosslib.LException(this.getClass(), \"Prvek tridy " 
						+ arrFormPopisy[ID_FORM_CLASS_NAME]  + " nema polozky pro vyberovy SELECT.\");\n";
				}
				sGetSelectFields = "if (item instanceof " + arrFormPopisy[ID_FORM_CLASS_NAME] + ") {\n"
          + sGetSelectFields + "\t\t} else ";
			
				// set a get metody
				arrFormPopisy[ID_FORM_SETGET_METODS] = sSetGetMetods;
				// datum
				arrFormPopisy[ID_FORM_DATE] = m_forDate.format(new Date());
        // pod pole
        arrFormPopisy[ID_FORM_SUBARRY] = sGetSubArrayFun + "\n" + sViews;
				// zmeny od uzivatele
				arrFormPopisy[ID_FORM_NEGENEROVANO] = "\n";
				// vazby na podrizene pole
				arrFormPopisy[ID_FORM_ATRIBUTES] += sGetSubArrayItem;
				
        // zapiseme do souboru
				Spinster.SaveToFile(sSourceDir + arrFormPopisy[ID_FORM_CLASS_NAME] + ".java", sFileClassSource, arrFormPopisy);

				// zmeny od uzivatele
				arrFormPopisy[ID_FORM_NEGENEROVANO] = "\n";
				// vytvorime tridu s polem prvku
				Spinster.SaveToFile(sSourceDir + arrFormPopisy[ID_FORM_CLASS_NAME] + "Array.java", sFileArraySource, arrFormPopisy);
        
        // trida s SQl prikazy
        arrSQLPopisy[2] += sGetSQL_SELECT;
        arrSQLPopisy[3] += sGetSQL_SELECT_ARRAY;
        arrSQLPopisy[4] += sGetSQL_INSERT;
        arrSQLPopisy[5] += sGetSelectSQL;
        arrSQLPopisy[6] += sGetSelectFields;
      }
      // trida s SQl prikazy
      arrSQLPopisy[1] = m_forDate.format(new Date());
      Spinster.SaveToFile(sSourceDir + sParamClass + ".java", sGetSQLParamSource, arrSQLPopisy);

      System.out.println("   VYGENEROVANO");
		} catch (SAXException sxe) {
		   	// Error generated during parsing
		   	Exception  x = sxe;
		   	if (sxe.getException() != null) {
				x = sxe.getException();
		   	}
		  	System.out.println("Generovani doslo k SAXException ["  + x + "]");
		} catch (ParserConfigurationException pce) {
		   	// Parser with specified options can't be built
		  	System.out.println("Generovani doslo k ParserConfigurationException ["  + pce + "]");
		} catch (IOException ioe) {
		   	// I/O error
		   	System.out.println("Generovani doslo k IOException ["  + ioe + "]");
		}
	}

	/** 
    * Zapise tridu do souboru
    * 
 	  * @param sFileName jmeno souboru s tridou
	  * @param sFileSourceTemp obsah vzoroveho souboru 
	  * @param arrPopisy jednotlive texty
	  * @return true pokud dopadne dobre  
	*/
  	public static boolean SaveToFile(String sFileName, String sFileSourceTemp, String[] arrPopisy) {
		// zapiseme do souboru
		try {
			boolean bIsNew = true;
			String sSource = "";
			File fSoubor = new File(sFileName); 
			// pokud pregenerovavame jiz meneny soubor zachovame to co napsal uzivatel 
			if (fSoubor.exists()) {
				String sTemp =  Spinster.LoadFile(sFileName);
				// najdeme generovane radky
				int nFirst = sTemp.indexOf("//@@@@ NEGENEROVANO"); 
        // pokud najdem, prepiseme
        if (nFirst != -1) {
          int nLast = sTemp.indexOf("//@@@@ NEGENEROVANO", nFirst + 1);
          arrPopisy[ID_FORM_NEGENEROVANO] = sTemp.substring(nFirst + 19, nLast);
  				bIsNew = false;
        }
			}
			// poskladame cely soubor
			sSource = MessageFormat.format(sFileSourceTemp, arrPopisy);
				
			BufferedWriter fWriter = null;
			fWriter = new BufferedWriter(new FileWriter(sFileName));
			// pokud se nepovede nacist
			if (fWriter == null) {
				System.out.println(" Nepodarilo se otevrit soubor [" + sFileName + "] ");
				return false;
			}
			fWriter.write(sSource);
			fWriter.close();
			
			// zapiseme 
			if (bIsNew) {
				System.out.println("   Vygenerovan [" + sFileName + "] ");
			} else {
				System.out.println("   Pregenerovan [" + sFileName + "] ");
			}
			
			return true;
		} catch (Exception e) {
			System.out.println(" Pri zapisu do souboru [" + sFileName + "] doslo k chybe [" + e.getMessage() + "]");
			return false;
		}
	}

	/** 
	  * Naformatuje defaultni hodnotu pro typ
	  *
	  * @param sFileName jmeno souboru se vzorem pro generovani   
	  * @return String vrati obsah vzoru
	*/
 	public static String LoadFile(String sFileName) {
  		String sSourceTemp = "";
		String sRadek = "";
		// zapiseme do souboru
		try {
			BufferedReader fBufReader = new BufferedReader(new FileReader(sFileName));
			while ((sRadek = fBufReader.readLine()) != null) {
				sSourceTemp += sRadek + "\n";
			}		
			fBufReader.close();
			return sSourceTemp;
		} catch (Exception e) {
			System.out.println(" Pri nacitani souboru [" + sFileName + "] doslo k chybe [" + e.getMessage() + "]");
			return null;
		}
	}

	/** 
	  * Naformatuje defaultni hodnotu pro typ
	  *
	  * @param sType typ
	  * @param sDef pripadna zadana default hodnota
	  * @return naformatovana defaultni hodnota
	*/
	public static String FindDefault(String sType, String sDef) {
		if (sType.equals("MeFieldDATE")) {
			return sDef.length() == 0 ? "" : sDef;
		} else if (sType.equals("MeFieldFLOAT")) {
			return sDef.length() == 0 ? "0" : sDef;
		} else if (sType.equals("MeFieldINT")) {
			return sDef.length() == 0 ? "0" : sDef;
		} else if (sType.equals("MeFieldREF")) {
			return sDef;
		} else if (sType.equals("MeFieldSTRING")) {
			return "\"" + sDef + "\"";
		}
		return ""; 
	}

	/** 
	  * Vrati pro dany objekt metody set.. a get..  
	  *
	  * @param sSetGetMetodsSource typ
	  * @param sName pripadna zadana default hodnota
	  * @return metody set.. a get..
	*/
	public static String GenerGetSetMetods(String sSetGetMetodsSource, String sName, String sType, String sRefClass) {
		String sJavaType = "";  
		String sFunType = "";
		if (sType.equals("MeFieldDATE")) {
			sJavaType = "java.util.Date";
			sFunType = "Date";
		} else if (sType.equals("MeFieldFLOAT")) {
			sJavaType = "float";
			sFunType = "Float";
		} else if (sType.equals("MeFieldINT")) {
			sJavaType = "int";
			sFunType = "Int";
		} else if (sType.equals("MeFieldREF")) {
			sJavaType = sRefClass;
			sFunType = "Ref";
		} else if (sType.equals("MeFieldSTRING")) {
			sJavaType = "String";
			sFunType = "String";
		}
		// Nastavime 1 a 3 pismeno velke
		String sFunName = String.valueOf(sName.charAt(0)).toUpperCase() + sName.charAt(1) 
			+ String.valueOf(sName.charAt(2)).toUpperCase();
		// pokud ma jmeno ..._id odrizneme
		if (sName.endsWith("_id")) {
			sFunName += sName.substring(3, sName.length() - 3);
		}
		else {
			sFunName += sName.substring(3);
		} 
		String[] paramSetGet = new String[] {sName, sType, sFunName, sJavaType, sFunType};
		return  MessageFormat.format(sSetGetMetodsSource, paramSetGet);
	}

	/** 
	  * Vypise spravne zadani
	  *
	*/
  	public static void PrintCommnadLine() {
	  System.out.println("\n");
	  System.out.println("Pozadovane zadani :");
	  System.out.println("Spinster <xmlfile=jmeno_xml> <sourcedir=jmeno_adresare> <paramclass=jmeno_param_tridy>");
	  System.out.println("  Parametry :");
	  System.out.println("  - jmeno_xml - jmeno souboru s definici trid ");
	  System.out.println("  - jmeno_adresare - jmeno adresare, do ktereho se ukladaji vygenerovane soubory ");
    System.out.println("  - jmeno_param_tridy - jmeno tridy s SQL prikazy pro objekty MeItem ");
	}

}